/** @file
  GPIO definition table

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2014 - 2015 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification
**/
#ifndef _GPIO_TABLE_IO_EXPANDER_H_
#define _GPIO_TABLE_IO_EXPANDER_H_

extern IO_EXPANDER_GPIO_CONFIG mGpioTableIoExpander[];
extern UINT16 mGpioTableIoExpanderSize;
extern IO_EXPANDER_GPIO_CONFIG mGpioTableIoExpanderKabylakeRvp3[];
extern UINT16 mGpioTableIoExpanderKabylakeRvp3Size;
extern IO_EXPANDER_GPIO_CONFIG mGpioTableIoExpanderKabylakeRDdr4[];
extern UINT16 mGpioTableIoExpanderSizeKabylakeRDdr4;

//IO Expander Table for SKL RVP5
static IO_EXPANDER_GPIO_CONFIG mGpioTableIoExpanderRvp5[] =
{
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_0,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_1,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_2,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_3,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_4,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_5,  IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_6,  IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_7,  IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_8,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_LOW,  IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},//PCH_SLOT1_RST_IOEXP_N
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_9,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_10, IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_11, IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_12, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_13, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_14, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_LOW,  IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_15, IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_16, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_17, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_18, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_19, IO_EXPANDER_GPIO_INPUT,  IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_20, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_21, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_LOW,  IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_22, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_0, IO_EXPANDER_GPIO_23, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_0,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_1,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_2,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_3,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_4,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_5,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_6,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_7,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_8,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_9,  IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
//skip to avoid overriding the setting changed in BIOS Menu {IO_EXPANDER_1, IO_EXPANDER_GPIO_10, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED},
  {IO_EXPANDER_1, IO_EXPANDER_GPIO_11, IO_EXPANDER_GPIO_OUTPUT, IO_EXPANDER_GPO_LEVEL_HIGH, IO_EXPANDER_GPI_INV_DISABLED, IO_EXPANDER_GPIO_RESERVED}
};

#endif
